//
//  MCProtocolState.h
//  MCNetComm
//
//  Created by Brent Gulanowski on 26/03/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface MCProtocolState : NSObject {

	NSString *name;
	NSString *activeParticipant;
	NSArray *validNextStates;
}

#if MAC_OS_X_VERSION_MAX_ALLOWED <= MAC_OS_X_VERSION_10_4
- (NSString *)name;
- (NSString *)activeParticipant;
- (void)setActiveParticipant:(NSString *)anActiveParticipant;
- (NSArray *)validNextStates;
- (void)setValidNextStates:(NSArray *)aValidNextStates;
#else
@property (readonly, copy) NSString *name;
@property (readonly, copy) NSString *activeParticipant;
@property (readonly, copy) NSArray *validNextStates;
#endif

+ (NSArray *)reservedStateNames;
+ (void)setReservedStateNames:(NSArray *)names;

// @throws NSInvalidArgumentException if aName is a reserved name
- (id)initWithName:(NSString *)aName activeParticipant:(NSString *)participantName validNextStates:(NSArray *)states;
- (id)initWithName:(NSString *)aName propertyList:(NSDictionary *)plist;

@end
